# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/)
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

Generated by [`auto-changelog`](https://github.com/CookPete/auto-changelog).

## [v1.12.0](https://github.com/alan-wu/flatmapvuer/compare/v1.12.0-beta.1...v1.12.0)

### Merged

- Sidebar not restoring sidebar state with connecitivityEntries [`#318`](https://github.com/alan-wu/flatmapvuer/pull/318)
- Fix and Test Flatmap API Server Error [`#315`](https://github.com/alan-wu/flatmapvuer/pull/315)
- Add an error when the server is unresponsive and does not return any … [`#43`](https://github.com/alan-wu/flatmapvuer/pull/43)
- Add Visual Component Test to Ensure Flatmap Features Are Rendered Correctly [`#307`](https://github.com/alan-wu/flatmapvuer/pull/307)
- Fix component tests [`#316`](https://github.com/alan-wu/flatmapvuer/pull/316)

### Commits

- Change visual test to compare with saved screenshot [`64369a6`](https://github.com/alan-wu/flatmapvuer/commit/64369a6a691f955885a3717b6f3fa19e08d37ab8)
- Add visual component test for test flatmap [`e32ae47`](https://github.com/alan-wu/flatmapvuer/commit/e32ae47160b78dcbce854ea44db08e3f45a8e1d6)
- Split component tests and fix alias issue [`76c00c3`](https://github.com/alan-wu/flatmapvuer/commit/76c00c3cbee0a29c199c0cf121452ddab8e5d724)

## [v1.12.0-beta.1](https://github.com/alan-wu/flatmapvuer/compare/v1.11.4...v1.12.0-beta.1) - 2025-10-20

### Merged

- Gracefully handle context event [`#314`](https://github.com/alan-wu/flatmapvuer/pull/314)
- Disable manual click event and trigger from search function [`#313`](https://github.com/alan-wu/flatmapvuer/pull/313)
- Centralise flatmap-viewer import [`#312`](https://github.com/alan-wu/flatmapvuer/pull/312)
- Help Mode Updates [`#309`](https://github.com/alan-wu/flatmapvuer/pull/309)
- Fix connectivity source check [`#311`](https://github.com/alan-wu/flatmapvuer/pull/311)

### Commits

- Initial implementation of context-restore [`d8c9af8`](https://github.com/alan-wu/flatmapvuer/commit/d8c9af8604900819505f10a1f64aa1b3a8445c67)
- Remove depdencies used in testing. [`8d39483`](https://github.com/alan-wu/flatmapvuer/commit/8d3948317ba4d0c476d6885ae0421fe3c3d214ea)
- Move legend-item into separate component [`3d1b8a8`](https://github.com/alan-wu/flatmapvuer/commit/3d1b8a82f079722badba4dd66b915bee0722ada9)

## [v1.11.4](https://github.com/alan-wu/flatmapvuer/compare/v1.11.3...v1.11.4) - 2025-10-03

### Merged

- Update flatmap-viewer 4.3.5 [`#308`](https://github.com/alan-wu/flatmapvuer/pull/308)
- Fix & Update Docs [`#306`](https://github.com/alan-wu/flatmapvuer/pull/306)
- Update deprecated FlatMap api method [`#302`](https://github.com/alan-wu/flatmapvuer/pull/302)
- Avoid using source in json data returned from knowledge query [`#303`](https://github.com/alan-wu/flatmapvuer/pull/303)
- Replace usage of id in flatmap callback event with models and featureId [`#301`](https://github.com/alan-wu/flatmapvuer/pull/301)
- Onscreen Message for Flatmap Loading Error [`#299`](https://github.com/alan-wu/flatmapvuer/pull/299)
- Update test-flatmap data for testing [`#300`](https://github.com/alan-wu/flatmapvuer/pull/300)

### Fixed

- Add annotationEvent for annotation popup to fix https://github.com/AnatomicMaps/flatmap-viewer/issues/62 [`#62`](https://github.com/AnatomicMaps/flatmap-viewer/issues/62)

### Commits

- Use flatmap-error component for error [`b860808`](https://github.com/alan-wu/flatmapvuer/commit/b86080861072df4efeb3b0fb9b76e91c9f32d88f)
- Refactor code for indentation [`b262cff`](https://github.com/alan-wu/flatmapvuer/commit/b262cffb599406bb3c7cefcdd5d448568a3bed2e)
- Add multiflatmapvuer flatmapAPI error [`f774a97`](https://github.com/alan-wu/flatmapvuer/commit/f774a973f992603747d1c4cb53c0bd9db3710928)

## [v1.11.3](https://github.com/alan-wu/flatmapvuer/compare/v1.11.2...v1.11.3) - 2025-09-03

### Merged

- Update flatmap-viewwer 4.3.0 to fix event callback data [`#298`](https://github.com/alan-wu/flatmapvuer/pull/298)
- Testing Update: Test Flatmap [`#297`](https://github.com/alan-wu/flatmapvuer/pull/297)

### Commits

- Update test-flatmap component testing data [`37d675f`](https://github.com/alan-wu/flatmapvuer/commit/37d675f520b300519bdf6e7b05c84b7722d2f299)
- Update test-flatmap UUID from mapImp [`018d400`](https://github.com/alan-wu/flatmapvuer/commit/018d4005bee21caed66ddedc6137926284d21550)
- update map-utilities. [`510c6c4`](https://github.com/alan-wu/flatmapvuer/commit/510c6c432dbabe44822c78c50f122e4375fbd19f)

## [v1.11.2](https://github.com/alan-wu/flatmapvuer/compare/v1.11.1...v1.11.2) - 2025-09-02

### Merged

- Fix issue for AC map without any legend. [`#296`](https://github.com/alan-wu/flatmapvuer/pull/296)
- Update dependency [`#295`](https://github.com/alan-wu/flatmapvuer/pull/295)

### Commits

- Update map-utilities. [`664f194`](https://github.com/alan-wu/flatmapvuer/commit/664f194b5faf82b7546c632e2d9056a924bc8e31)

## [v1.11.1](https://github.com/alan-wu/flatmapvuer/compare/v1.11.0...v1.11.1) - 2025-08-27

### Merged

- Update style and fix popover [`#292`](https://github.com/alan-wu/flatmapvuer/pull/292)
- Update flatmapvuer version. [`#33`](https://github.com/alan-wu/flatmapvuer/pull/33)
- Sync legend style changes [`#32`](https://github.com/alan-wu/flatmapvuer/pull/32)

### Commits

- Update star class [`f11ec2d`](https://github.com/alan-wu/flatmapvuer/commit/f11ec2d2b03042dcd426aea095572b26bc89d057)
- Support exoid with border. [`c3fd11c`](https://github.com/alan-wu/flatmapvuer/commit/c3fd11c59cc0996b684aa678edf06c26f9be8fff)
- Add star, rsquare and square style. Rename hexagon-star to an exoid. [`2543909`](https://github.com/alan-wu/flatmapvuer/commit/2543909935acc17f188194597f9d0baaf2aa9521)

## [v1.11.0](https://github.com/alan-wu/flatmapvuer/compare/v1.10.2...v1.11.0) - 2025-08-20

### Merged

- Add origin-via-destination filters for scaffold [`#293`](https://github.com/alan-wu/flatmapvuer/pull/293)
- Scaffold neuron connectivity [`#289`](https://github.com/alan-wu/flatmapvuer/pull/289)
- Highlight reset support [`#277`](https://github.com/alan-wu/flatmapvuer/pull/277)
- Legends update [`#291`](https://github.com/alan-wu/flatmapvuer/pull/291)
- Connectivity Exploration Mode [`#279`](https://github.com/alan-wu/flatmapvuer/pull/279)
- Legend udpate [`#288`](https://github.com/alan-wu/flatmapvuer/pull/288)

### Commits

- Revert back changelog updates [`29b6aa2`](https://github.com/alan-wu/flatmapvuer/commit/29b6aa228e2f26c9b089cfd570d68e52d5968628)
- Undo changelog updates [`871af8a`](https://github.com/alan-wu/flatmapvuer/commit/871af8a81e079b8774ebd9e4d30ac16a5c649f26)
- Minor changes. [`7d74f7e`](https://github.com/alan-wu/flatmapvuer/commit/7d74f7ed1cc7a20f2c67d20a5ebc7ccec7ef31e8)

## [v1.10.2](https://github.com/alan-wu/flatmapvuer/compare/v1.10.1...v1.10.2) - 2025-07-08

### Merged

- Update alert filter expression [`#284`](https://github.com/alan-wu/flatmapvuer/pull/284)
- Image render testing [`#286`](https://github.com/alan-wu/flatmapvuer/pull/286)
- Image render testing - readySpy [`#31`](https://github.com/alan-wu/flatmapvuer/pull/31)
- Sort by label [`#285`](https://github.com/alan-wu/flatmapvuer/pull/285)

### Commits

- Add image rendering testing [`e1d80f9`](https://github.com/alan-wu/flatmapvuer/commit/e1d80f9fe32ce3fa149fb85830cc59e04588aa91)
- Create cy.loadMultiFlatmap() [`1b57bbf`](https://github.com/alan-wu/flatmapvuer/commit/1b57bbf875ea6f28c1d99630cb4a41e1e9056bde)
- Separate testing based on serve and species [`261ed47`](https://github.com/alan-wu/flatmapvuer/commit/261ed47f7d211271349c5055491e9c475a89e9ee)

## [v1.10.1](https://github.com/alan-wu/flatmapvuer/compare/v1.10.0...v1.10.1) - 2025-07-03

### Merged

- Update valid pathways filter options [`#280`](https://github.com/alan-wu/flatmapvuer/pull/280)
- Add option to show left hand side filter as legend [`#276`](https://github.com/alan-wu/flatmapvuer/pull/276)
- Filter visibility [`#252`](https://github.com/alan-wu/flatmapvuer/pull/252)

### Commits

- Add setVisibilityFilter [`522cc7e`](https://github.com/alan-wu/flatmapvuer/commit/522cc7e6926c04ced35889538e7e64b31976a532)
- Minor update [`4341bde`](https://github.com/alan-wu/flatmapvuer/commit/4341bde8517d1ac6c300c1eb0b9236e0548f6e7a)

## [v1.10.0](https://github.com/alan-wu/flatmapvuer/compare/v1.9.2...v1.10.0) - 2025-06-25

### Merged

- Add style when generate filter [`#274`](https://github.com/alan-wu/flatmapvuer/pull/274)
- Replace pathModelNodes [`#272`](https://github.com/alan-wu/flatmapvuer/pull/272)
- Emit emitOfflineAnnotationUpdate for Annotation Mode in Global Settings Toolbar  [`#267`](https://github.com/alan-wu/flatmapvuer/pull/267)
- Fix tooltip and remove duplicate codes [`#266`](https://github.com/alan-wu/flatmapvuer/pull/266)
- Explorer filter [`#262`](https://github.com/alan-wu/flatmapvuer/pull/262)
- Remove pathways query since it is available on mapImp.pathways [`#268`](https://github.com/alan-wu/flatmapvuer/pull/268)
- Update explorer card display [`#265`](https://github.com/alan-wu/flatmapvuer/pull/265)
- Fix multi map copies [`#264`](https://github.com/alan-wu/flatmapvuer/pull/264)
- Prevent creating popup for empty background area click [`#263`](https://github.com/alan-wu/flatmapvuer/pull/263)
- Feature/global settings [`#256`](https://github.com/alan-wu/flatmapvuer/pull/256)

### Commits

- Externalise flatmap-viewer. [`4a79bdf`](https://github.com/alan-wu/flatmapvuer/commit/4a79bdf067d39d153fd67bc5227360fec2b4cc77)
- Add function to generate filter options [`91367ab`](https://github.com/alan-wu/flatmapvuer/commit/91367abb53144a384f38b16995f9ccc952391fac)
- Generate related ids for filter options [`af3e893`](https://github.com/alan-wu/flatmapvuer/commit/af3e8939890207e15802b76b8ce7a3a076e615b3)

## [v1.9.2](https://github.com/alan-wu/flatmapvuer/compare/v1.9.1...v1.9.2) - 2025-05-27

### Merged

- Fix split screen search [`#260`](https://github.com/alan-wu/flatmapvuer/pull/260)

### Commits

- Make sure update data using the correct map [`9a12baa`](https://github.com/alan-wu/flatmapvuer/commit/9a12baabeb932570c5b070220126daa689c5ee33)

## [v1.9.1](https://github.com/alan-wu/flatmapvuer/compare/v1.9.0...v1.9.1) - 2025-05-26

### Merged

- Fix duplicate data on click [`#258`](https://github.com/alan-wu/flatmapvuer/pull/258)
- Add reset connectivity explorer list when clicking on empty map area [`#247`](https://github.com/alan-wu/flatmapvuer/pull/247)
- Connectivity explorer tab with multiple neuron selection [`#35`](https://github.com/alan-wu/flatmapvuer/pull/35)

### Commits

- Fix multi neuron selection select [`d735adf`](https://github.com/alan-wu/flatmapvuer/commit/d735adff0798b973d020756fa8a94dba1f70a247)
- Fix missing features alert for display search #241 [`4fc80ff`](https://github.com/alan-wu/flatmapvuer/commit/4fc80fffbcfeb744b3091d7d49c86e72de5226cb)

## [v1.9.0](https://github.com/alan-wu/flatmapvuer/compare/v1.8.2...v1.9.0) - 2025-05-23

### Merged

- Disable connection from features [`#255`](https://github.com/alan-wu/flatmapvuer/pull/255)
- Feature: connectivity knowledge multiview [`#250`](https://github.com/alan-wu/flatmapvuer/pull/250)
- Add alert filter testing [`#251`](https://github.com/alan-wu/flatmapvuer/pull/251)
- Magnify glass search [`#248`](https://github.com/alan-wu/flatmapvuer/pull/248)
- Connectivity explorer [`#246`](https://github.com/alan-wu/flatmapvuer/pull/246)
- Update variable name to be consistent [`#245`](https://github.com/alan-wu/flatmapvuer/pull/245)
- Add new API request to get paths from the map [`#28`](https://github.com/alan-wu/flatmapvuer/pull/28)
- Rename offline annotation [`#244`](https://github.com/alan-wu/flatmapvuer/pull/244)
- Remove duplicate origins in connectivity [`#243`](https://github.com/alan-wu/flatmapvuer/pull/243)
- Offline annotation [`#237`](https://github.com/alan-wu/flatmapvuer/pull/237)
- Update flatmapvuer [`#27`](https://github.com/alan-wu/flatmapvuer/pull/27)
- Connectivity explorer tab with multiple neuron selection [`#26`](https://github.com/alan-wu/flatmapvuer/pull/26)
- Connectivity explorer tab with multiple neuron selection [`#25`](https://github.com/alan-wu/flatmapvuer/pull/25)
- Sort connectivity list [`#242`](https://github.com/alan-wu/flatmapvuer/pull/242)
- Fix missing features alert for display search [`#241`](https://github.com/alan-wu/flatmapvuer/pull/241)

### Commits

- Update dependencies. [`42ab67a`](https://github.com/alan-wu/flatmapvuer/commit/42ab67af26b2a10240cfc68808085f14afdf0db4)
- Add cypress-visual-regression [`a2be507`](https://github.com/alan-wu/flatmapvuer/commit/a2be507f4e2356eb62b2c979acc89186b68c7fc8)
- Externalise some packages. [`7c18f66`](https://github.com/alan-wu/flatmapvuer/commit/7c18f6638961d93ec8f06ce5fe36db4d22cf23b9)

## [v1.8.2](https://github.com/alan-wu/flatmapvuer/compare/v1.8.0...v1.8.2) - 2025-04-14

### Merged

- Connectivity process update [`#240`](https://github.com/alan-wu/flatmapvuer/pull/240)

### Commits

- Make sure connectivity type is correct [`3200372`](https://github.com/alan-wu/flatmapvuer/commit/3200372ecbe7b39e7bfec2c437b9c92084f3421d)
- Use old variable names [`ab3644f`](https://github.com/alan-wu/flatmapvuer/commit/ab3644f3635fbc258c92f67e1fa0dbfc9ed35825)
- Backward support knowledge without phenotypes information. [`7db9e42`](https://github.com/alan-wu/flatmapvuer/commit/7db9e4253517557e9f0293f870358fc6908e80c0)

## [v1.8.0](https://github.com/alan-wu/flatmapvuer/compare/v1.7.3...v1.8.0) - 2025-02-28

### Merged

- Fix rollup dependencies [`#235`](https://github.com/alan-wu/flatmapvuer/pull/235)
- Improve in display search [`#227`](https://github.com/alan-wu/flatmapvuer/pull/227)
- Display connections with evidence from published sources [`#230`](https://github.com/alan-wu/flatmapvuer/pull/230)
- Fix highlight paths reset on different viewing modes [`#233`](https://github.com/alan-wu/flatmapvuer/pull/233)
- Connections highlight fix [`#232`](https://github.com/alan-wu/flatmapvuer/pull/232)
- Add event delay when mouse move out of taxon area [`#231`](https://github.com/alan-wu/flatmapvuer/pull/231)
- Update flatmap-viewer 3.2.13 [`#229`](https://github.com/alan-wu/flatmapvuer/pull/229)
- SCKAN version in connectivity graph [`#228`](https://github.com/alan-wu/flatmapvuer/pull/228)
- Highlight correct geojson id for connectivity mouse over [`#225`](https://github.com/alan-wu/flatmapvuer/pull/225)

### Commits

- Update map-utilities. [`efcebe5`](https://github.com/alan-wu/flatmapvuer/commit/efcebe577e0b53eeec99d18374239d653a47ed33)
- Update package-lock.json [`af8efb1`](https://github.com/alan-wu/flatmapvuer/commit/af8efb134e2e290935b13cf7a495fae8a945314a)
- Move flatmap knowledge functions to flatmapQueries [`0eb4b01`](https://github.com/alan-wu/flatmapvuer/commit/0eb4b0105d810135786b20dd91062baf91eedb53)

## [v1.7.3](https://github.com/alan-wu/flatmapvuer/compare/v1.7.2...v1.7.3) - 2025-01-17

### Merged

- Fix hover over the map after connectivity tooltip shown [`#224`](https://github.com/alan-wu/flatmapvuer/pull/224)
- Update flatmap-viewer 3.2.11 [`#223`](https://github.com/alan-wu/flatmapvuer/pull/223)

### Commits

- Update map-utilities. [`715622f`](https://github.com/alan-wu/flatmapvuer/commit/715622f7079652f6fefd9ca2bc5dd022415fb1f9)
- Update flatmap-viewer 3.2.12 [`92085fd`](https://github.com/alan-wu/flatmapvuer/commit/92085fdcd552b2e70c6ce832733656a3d67015b6)
- Fix style issue on connectivity tooltip [`9074361`](https://github.com/alan-wu/flatmapvuer/commit/9074361501e7f6c3e285b6473a04b7ebe62c8ce9)

## [v1.7.2](https://github.com/alan-wu/flatmapvuer/compare/v1.7.1...v1.7.2) - 2025-01-10

### Commits

- Update What's new? [`b56edbf`](https://github.com/alan-wu/flatmapvuer/commit/b56edbf45cbfc3c97a8c8215707336e396c3be2c)

## [v1.7.1](https://github.com/alan-wu/flatmapvuer/compare/v1.7.0...v1.7.1) - 2025-01-10

### Commits

- Improve warning display and remove them from some demo maps. [`c5aae37`](https://github.com/alan-wu/flatmapvuer/commit/c5aae3742e4aa6e29eff34ed32850b28ac86b653)
- Update to map-utilities 1.3.1 [`d52492f`](https://github.com/alan-wu/flatmapvuer/commit/d52492f28d600d406b9a11f95331bdfdaf033e11)

## [v1.7.0](https://github.com/alan-wu/flatmapvuer/compare/v1.6.2...v1.7.0) - 2025-01-08

### Merged

- Disable zoom on connectivity highlight [`#217`](https://github.com/alan-wu/flatmapvuer/pull/217)
- Refactor the display of evidence for SCKAN connectivity [`#221`](https://github.com/alan-wu/flatmapvuer/pull/221)
- More annotation tool update [`#216`](https://github.com/alan-wu/flatmapvuer/pull/216)
- Replace Rat (NPO) with Human male for testing  [`#222`](https://github.com/alan-wu/flatmapvuer/pull/222)
- Fix CORS errors for searching multiple PubMed IDs [`#220`](https://github.com/alan-wu/flatmapvuer/pull/220)
- Fix an issue with undefined label with searchAndShowResult. [`#219`](https://github.com/alan-wu/flatmapvuer/pull/219)
- Hide left drawer when there is no filter and legend. [`#215`](https://github.com/alan-wu/flatmapvuer/pull/215)
- Use a single map manager for different flatmap instances [`#213`](https://github.com/alan-wu/flatmapvuer/pull/213)

### Commits

- Update map-utilities [`b82746b`](https://github.com/alan-wu/flatmapvuer/commit/b82746b155ce269766d2a5c2f23649b0466445ea)
- Fix a bug. [`380abca`](https://github.com/alan-wu/flatmapvuer/commit/380abca550df06d02eb2a8f857db7e450ce1dfef)
- Resolve conflicts. [`cc18808`](https://github.com/alan-wu/flatmapvuer/commit/cc188081bff2678a6d0c8217112c64d5d195559f)

## [v1.6.2](https://github.com/alan-wu/flatmapvuer/compare/v1.6.1...v1.6.2) - 2024-12-17

### Commits

- Update flatmap-viewer. [`b60a666`](https://github.com/alan-wu/flatmapvuer/commit/b60a66603b441432e89fcd6f581b368593ce63dd)
- Resolve dependencies warning. [`bf9da38`](https://github.com/alan-wu/flatmapvuer/commit/bf9da38019074487691116a31551918fa8a5272a)

## [v1.6.1](https://github.com/alan-wu/flatmapvuer/compare/v1.5.6...v1.6.1) - 2024-11-25

### Merged

- Connectivity graph tooltips [`#210`](https://github.com/alan-wu/flatmapvuer/pull/210)
- Improve UX when invalid drawing happens [`#212`](https://github.com/alan-wu/flatmapvuer/pull/212)
- Annotation sidebar fix [`#211`](https://github.com/alan-wu/flatmapvuer/pull/211)
- Add supports to external annotation tool display (sidebar). [`#205`](https://github.com/alan-wu/flatmapvuer/pull/205)
- Fit To Window Bugfix [`#208`](https://github.com/alan-wu/flatmapvuer/pull/208)
- Clear invalid drawn feature [`#6`](https://github.com/alan-wu/flatmapvuer/pull/6)
- State saving [`#207`](https://github.com/alan-wu/flatmapvuer/pull/207)
- Remove checkbox label purple color [`#209`](https://github.com/alan-wu/flatmapvuer/pull/209)
- Flatmap-viewer API Updates  [`#197`](https://github.com/alan-wu/flatmapvuer/pull/197)
- Fix species z-index [`#206`](https://github.com/alan-wu/flatmapvuer/pull/206)
- Fix #202 pathways container zindex [`#203`](https://github.com/alan-wu/flatmapvuer/pull/203)
- Update species select UI to fit content width [`#204`](https://github.com/alan-wu/flatmapvuer/pull/204)
- Remove warning. [`#201`](https://github.com/alan-wu/flatmapvuer/pull/201)

### Fixed

- Merge pull request #203 from akhuoa/bugfix/pathways-container-zindex [`#202`](https://github.com/alan-wu/flatmapvuer/issues/202)
- Fix #202 pathways container zindex [`#202`](https://github.com/alan-wu/flatmapvuer/issues/202)

### Commits

- Add show connectivity tooltip method [`472f336`](https://github.com/alan-wu/flatmapvuer/commit/472f336a87871d3f2db92ed3f4e03a04c3484ffa)
- Avoid duplicate listeners [`f7b5382`](https://github.com/alan-wu/flatmapvuer/commit/f7b538228073c2dc7f70737d78b5e168af088d6f)
- Remove centreline [`f8111fd`](https://github.com/alan-wu/flatmapvuer/commit/f8111fdde85a835ea511f1926428c3676eebdf77)

## [v1.5.6](https://github.com/alan-wu/flatmapvuer/compare/v1.5.5...v1.5.6) - 2024-10-16

### Merged

- Fix PubMed URL resolve for empty result [`#200`](https://github.com/alan-wu/flatmapvuer/pull/200)
- Update vagus flatmap UBERON identifier [`#199`](https://github.com/alan-wu/flatmapvuer/pull/199)
- UI Updates [`#198`](https://github.com/alan-wu/flatmapvuer/pull/198)

### Commits

- Fix pubmed url resolve for empty result [`93a7b9e`](https://github.com/alan-wu/flatmapvuer/commit/93a7b9eba6903eae3c0a5a12b0a1492c44486a4d)
- Fix pathway container close position without using fixed width for scrollbar issue [`dac1bd7`](https://github.com/alan-wu/flatmapvuer/commit/dac1bd7d135581d4ac4c14b483dd540425f9ef97)
- Fix the gap between left border and pathway container close button [`78edbe3`](https://github.com/alan-wu/flatmapvuer/commit/78edbe34a46b0bf739acf709846d9172e4f5676c)

## [v1.5.5](https://github.com/alan-wu/flatmapvuer/compare/v1.5.3...v1.5.5) - 2024-10-09

### Commits

- Update vue and element-plus. [`5fee243`](https://github.com/alan-wu/flatmapvuer/commit/5fee243b1f8f291c59e383292a9ac79247c05923)
- Update dependencies. [`18a1443`](https://github.com/alan-wu/flatmapvuer/commit/18a144373f6247c7724eae0be7b75b917288c56c)

## [v1.5.3](https://github.com/alan-wu/flatmapvuer/compare/v1.5.1...v1.5.3) - 2024-10-09

### Merged

- Security updates [`#196`](https://github.com/alan-wu/flatmapvuer/pull/196)
- Patch release 1.5.2 [`#195`](https://github.com/alan-wu/flatmapvuer/pull/195)
- Update flatmap-viewer to show marker for vagus nerve [`#194`](https://github.com/alan-wu/flatmapvuer/pull/194)
- Fix auth issue [`#193`](https://github.com/alan-wu/flatmapvuer/pull/193)

### Commits

- Remove unused cypress/webpack-dev-server for security fix [`381d947`](https://github.com/alan-wu/flatmapvuer/commit/381d947cc8e7a25926f4437d7d78e494734564b6)
- Switch from vuese/parser to vue-docgen-api for componennt documenntation [`27455f1`](https://github.com/alan-wu/flatmapvuer/commit/27455f18d6cadc03a4e1b575568e2e3f59eed3c1)
- Update changelog.md [`66c0dbb`](https://github.com/alan-wu/flatmapvuer/commit/66c0dbb33048dc12eda439434f8f954356364b3f)

## [v1.5.1](https://github.com/alan-wu/flatmapvuer/compare/v1.5.0...v1.5.1) - 2024-09-19

### Commits

- Fix an issue with biological sex not set correctly when taxon is not set on state. [`02a3b1e`](https://github.com/alan-wu/flatmapvuer/commit/02a3b1ec919b668686091b86496b936aee4ccbd2)

## [v1.5.0](https://github.com/alan-wu/flatmapvuer/compare/v1.4.4...v1.5.0) - 2024-09-19

### Merged

- Handle pubmed query differently. [`#192`](https://github.com/alan-wu/flatmapvuer/pull/192)

## [v1.4.4](https://github.com/alan-wu/flatmapvuer/compare/v1.4.3...v1.4.4) - 2024-09-12

### Commits

- Update flatmap-viewer which fixes an issue on the minimap. [`4b763b9`](https://github.com/alan-wu/flatmapvuer/commit/4b763b928c54e6a46c7b4b538bfaeb38f87e6f34)

## [v1.4.3](https://github.com/alan-wu/flatmapvuer/compare/v1.4.2...v1.4.3) - 2024-09-03

### Merged

- Update flatmap-viewer which fixes an issue with geojson related call. [`#191`](https://github.com/alan-wu/flatmapvuer/pull/191)

### Commits

- Update flatmap-viewer which fixes an issue with selectGeoJSONFeatures call. [`0745f7e`](https://github.com/alan-wu/flatmapvuer/commit/0745f7e5b318c483b18720398ef88d829d893f05)

## [v1.4.2](https://github.com/alan-wu/flatmapvuer/compare/v1.4.1...v1.4.2) - 2024-09-02

### Merged

- Help mode bugfix [`#190`](https://github.com/alan-wu/flatmapvuer/pull/190)
- Remove error log from abortController [`#189`](https://github.com/alan-wu/flatmapvuer/pull/189)

### Commits

- Fix help mode svg icon highlight for Safari [`524f589`](https://github.com/alan-wu/flatmapvuer/commit/524f5897de2a80335e010981c02b93c0c14c9d60)
- Update README.md [`71e3072`](https://github.com/alan-wu/flatmapvuer/commit/71e3072438dc0c5b48eec3d43fd5db29f71ad78f)
- Fix help-mode index [`f77a321`](https://github.com/alan-wu/flatmapvuer/commit/f77a321120b8f96a298e3052a80fffbad2f75261)

## [v1.4.1](https://github.com/alan-wu/flatmapvuer/compare/v1.4.0...v1.4.1) - 2024-08-22

### Merged

- Update to Flatmap-viewer version 3.1.4. [`#187`](https://github.com/alan-wu/flatmapvuer/pull/187)

### Commits

- Update to version 3.1.4. [`3bba246`](https://github.com/alan-wu/flatmapvuer/commit/3bba2462ebc26b7381e6aa96370bbb7ecbaf7905)
- Improve README.md. [`284cc20`](https://github.com/alan-wu/flatmapvuer/commit/284cc2043d059076a4acc3ad501caa059966fc05)

## [v1.4.0](https://github.com/alan-wu/flatmapvuer/compare/v1.3.2...v1.4.0) - 2024-08-16

### Merged

- Add species legend to the FC map [`#186`](https://github.com/alan-wu/flatmapvuer/pull/186)
- Fix beta tooltip index [`#185`](https://github.com/alan-wu/flatmapvuer/pull/185)
- Map annotation shortcut [`#183`](https://github.com/alan-wu/flatmapvuer/pull/183)
- Fix missing features alert [`#182`](https://github.com/alan-wu/flatmapvuer/pull/182)
- Replace global variable with markRaw [`#181`](https://github.com/alan-wu/flatmapvuer/pull/181)

### Commits

- Modify code to provide change viewing mode api [`adca34e`](https://github.com/alan-wu/flatmapvuer/commit/adca34e4c114b04013a22363e1bd201d5df69b84)
- Update to the latest packages. [`6bf41fd`](https://github.com/alan-wu/flatmapvuer/commit/6bf41fd2e69bfb38397b3f005c6a9e168472fc62)
- Beta release v1.3.2-beta.2 [`883760f`](https://github.com/alan-wu/flatmapvuer/commit/883760f8d35b004c74e250de16ae72f72106237f)

## [v1.3.2](https://github.com/alan-wu/flatmapvuer/compare/v1.3.1...v1.3.2) - 2024-07-22

### Merged

- Release v-1.3.2 [`#180`](https://github.com/alan-wu/flatmapvuer/pull/180)
- Hide connectivity info for empty tooltip data [`#179`](https://github.com/alan-wu/flatmapvuer/pull/179)

### Commits

- Fix empty tooltip checking function [`54a8498`](https://github.com/alan-wu/flatmapvuer/commit/54a8498c043434effd997d17ebdfd62ae087e7a6)
- Update to beta version 1.3.2-beta.1 [`5476730`](https://github.com/alan-wu/flatmapvuer/commit/5476730548f78a9a078270ebe8610f6f91daadc5)
- Rename function to be more meaningful [`aa370f8`](https://github.com/alan-wu/flatmapvuer/commit/aa370f8cac39746e22270a7505969789915738fd)

## [v1.3.1](https://github.com/alan-wu/flatmapvuer/compare/v1.3.0...v1.3.1) - 2024-07-10

### Commits

- Update map-utilties to version 1.3.0. [`013c45b`](https://github.com/alan-wu/flatmapvuer/commit/013c45b2de7d401dc9937b4b550b10071f820ba5)

## [v1.3.0](https://github.com/alan-wu/flatmapvuer/compare/v1.2.0...v1.3.0) - 2024-07-10

### Merged

- Display connectivity info without obstructing current map view [`#175`](https://github.com/alan-wu/flatmapvuer/pull/175)
- Revert "Fix PubMed URL issue" [`#177`](https://github.com/alan-wu/flatmapvuer/pull/177)
- Fix PubMed URL issue [`#176`](https://github.com/alan-wu/flatmapvuer/pull/176)
- Utilities package [`#174`](https://github.com/alan-wu/flatmapvuer/pull/174)

### Commits

- Replace local components by map-utilities package [`e59cf6e`](https://github.com/alan-wu/flatmapvuer/commit/e59cf6e284a99d3abae12248e6da6b7a4b1cbe33)
- Update code for upcoming toolbar component [`94e38f4`](https://github.com/alan-wu/flatmapvuer/commit/94e38f47c48226f759b24c59f53ea119cce61331)
- Update code for upcoming treecontrols component [`ab31662`](https://github.com/alan-wu/flatmapvuer/commit/ab316621cfeeee234eeaf5a7b54de039f4a09bd6)

## [v1.2.0](https://github.com/alan-wu/flatmapvuer/compare/v1.1.1...v1.2.0) - 2024-06-24

### Merged

- Update to how modes are selected [`#170`](https://github.com/alan-wu/flatmapvuer/pull/170)
- Switch to latest version of flatmap-viewer [`#173`](https://github.com/alan-wu/flatmapvuer/pull/173)
- Update marker icon for help mode [`#6`](https://github.com/alan-wu/flatmapvuer/pull/6)

### Commits

- Switch the mode selector to a title/subtitle style [`13f1ff7`](https://github.com/alan-wu/flatmapvuer/commit/13f1ff79eb903ce2103d9d289b95dd4f161d1009)
- Switch network discover mode to 'neuron connections' mode and add help text [`2d4f050`](https://github.com/alan-wu/flatmapvuer/commit/2d4f050ca1011c1272d1515e8be5993fbba5d8ca)
- Maintain viewing modes order. [`bb1dc6a`](https://github.com/alan-wu/flatmapvuer/commit/bb1dc6ae5609869935e46c4fd235d9c2badfb1ea)

## [v1.1.1](https://github.com/alan-wu/flatmapvuer/compare/v1.1.0...v1.1.1) - 2024-06-06

### Merged

- UI updates for FC map pathway container [`#171`](https://github.com/alan-wu/flatmapvuer/pull/171)
- Now can handle single and double nodes at all times [`#169`](https://github.com/alan-wu/flatmapvuer/pull/169)

### Commits

- Add a fix to cypress testing. [`aa8de18`](https://github.com/alan-wu/flatmapvuer/commit/aa8de189572cb34ba584f99cc895926b79ed7d22)
- Make improvements on TreeControls UI [`72fe2ee`](https://github.com/alan-wu/flatmapvuer/commit/72fe2ee54f6b257d870d3ff7bf4dbe336c2e98dd)
- Update cypress testing. [`266c29c`](https://github.com/alan-wu/flatmapvuer/commit/266c29c28d2c25665f49267f7953abb6fcf46daa)

## [v1.1.0](https://github.com/alan-wu/flatmapvuer/compare/v1.0.2...v1.1.0) - 2024-05-29

### Merged

- Remove origins from highlight in network explorer mode: [`#144`](https://github.com/alan-wu/flatmapvuer/pull/144)
- Toolbar icon style [`#168`](https://github.com/alan-wu/flatmapvuer/pull/168)
- fix toolbar when Drawn By specified [`#167`](https://github.com/alan-wu/flatmapvuer/pull/167)
- New draw feature for Annotator  [`#142`](https://github.com/alan-wu/flatmapvuer/pull/142)
- Refactor [`#14`](https://github.com/alan-wu/flatmapvuer/pull/14)
- Add features alert [`#161`](https://github.com/alan-wu/flatmapvuer/pull/161)
- Supports the old help mode without help dialog. [`#166`](https://github.com/alan-wu/flatmapvuer/pull/166)
- Flatmap improvements - help text visible [`#165`](https://github.com/alan-wu/flatmapvuer/pull/165)
- Highlight on species [`#127`](https://github.com/alan-wu/flatmapvuer/pull/127)
- Add relation between drawn features [`#13`](https://github.com/alan-wu/flatmapvuer/pull/13)
- Refactor annotator code [`#12`](https://github.com/alan-wu/flatmapvuer/pull/12)
- Send item details when adding an annotation. [`#11`](https://github.com/alan-wu/flatmapvuer/pull/11)
- A tidy up and pass more connection information to the annotation service [`#10`](https://github.com/alan-wu/flatmapvuer/pull/10)
- Annotator further development [`#8`](https://github.com/alan-wu/flatmapvuer/pull/8)
- Viewer changes merged [`#7`](https://github.com/alan-wu/flatmapvuer/pull/7)
- pull requirements [`#6`](https://github.com/alan-wu/flatmapvuer/pull/6)
- pull latest changes [`#4`](https://github.com/alan-wu/flatmapvuer/pull/4)
- Merge new changes [`#3`](https://github.com/alan-wu/flatmapvuer/pull/3)
- Vue3 migration [`#2`](https://github.com/alan-wu/flatmapvuer/pull/2)

### Commits

- Update package-lock.json. [`4300265`](https://github.com/alan-wu/flatmapvuer/commit/4300265d0b175e003d937c225765466219d1663a)
- Remove console message. [`eeaa6cc`](https://github.com/alan-wu/flatmapvuer/commit/eeaa6cc0f309b880fef4d66c01abd14eb804f1c0)
- move dialog display control into draw tool component [`aafa7a8`](https://github.com/alan-wu/flatmapvuer/commit/aafa7a87e4cdbf5dc576f09534f6b21fc4f1eb93)

## [v1.0.2](https://github.com/alan-wu/flatmapvuer/compare/v1.0.1...v1.0.2) - 2024-05-15

### Merged

- Bugfix - Help Mode Tooltips [`#164`](https://github.com/alan-wu/flatmapvuer/pull/164)
- Add pathways checkbox events for data tracking [`#163`](https://github.com/alan-wu/flatmapvuer/pull/163)

### Commits

- Fix featured dataset tooltip and help mode [`883e6c5`](https://github.com/alan-wu/flatmapvuer/commit/883e6c5acf243abda7f0da047a80ff7af3677f95)
- Open drawer to show tooltips inside when help mode is activated [`82b1ce6`](https://github.com/alan-wu/flatmapvuer/commit/82b1ce6405e6e6dac31f0e959010b06c7aa2f268)
- Add open pubmed button click event [`782145d`](https://github.com/alan-wu/flatmapvuer/commit/782145d4641f173c992c36792eacf960b2456e3c)

## [v1.0.1](https://github.com/alan-wu/flatmapvuer/compare/v1.0.0...v1.0.1) - 2024-05-02

### Merged

- Add species switch in component testing [`#150`](https://github.com/alan-wu/flatmapvuer/pull/150)

### Commits

- Update changelogs. [`164211a`](https://github.com/alan-wu/flatmapvuer/commit/164211aafed94962d79666caabe8e7df15726912)
- Update test for species switch [`5cba70e`](https://github.com/alan-wu/flatmapvuer/commit/5cba70e6310fe5339017b8140c91d16e3b883b79)
- Fix a typo. [`6feeab9`](https://github.com/alan-wu/flatmapvuer/commit/6feeab9a33e1ba2a4960a1a344442fa864a7c582)

## [v1.0.0](https://github.com/alan-wu/flatmapvuer/compare/v0.5.9...v1.0.0) - 2024-04-24

### Merged

- Fix popup close error [`#160`](https://github.com/alan-wu/flatmapvuer/pull/160)
- Fix tooltip arrow on top position [`#159`](https://github.com/alan-wu/flatmapvuer/pull/159)
- Fix api docs demo for pinia [`#158`](https://github.com/alan-wu/flatmapvuer/pull/158)
- Fix popup showing on switching viewingMode [`#157`](https://github.com/alan-wu/flatmapvuer/pull/157)
- Popup UI Updates [`#156`](https://github.com/alan-wu/flatmapvuer/pull/156)
- Fix tooltip arrows UI for corner positions [Bugfix] [UI] [`#153`](https://github.com/alan-wu/flatmapvuer/pull/153)
- Update vitepress config with alias to resolve dir [`#148`](https://github.com/alan-wu/flatmapvuer/pull/148)
- Update flatmapvuer. [`#147`](https://github.com/alan-wu/flatmapvuer/pull/147)
- Add pinia in Cypress component test [`#4`](https://github.com/alan-wu/flatmapvuer/pull/4)
- Annotation authentication [`#143`](https://github.com/alan-wu/flatmapvuer/pull/143)
- Fix a bug causing annotation to not open the editing dialog. [`#9`](https://github.com/alan-wu/flatmapvuer/pull/9)
- Update docs content [`#146`](https://github.com/alan-wu/flatmapvuer/pull/146)
- Cleanup unused npm packages [`#137`](https://github.com/alan-wu/flatmapvuer/pull/137)
- Make flatmap query helper functions more robust [`#141`](https://github.com/alan-wu/flatmapvuer/pull/141)
- Change Flight Path Option [`#140`](https://github.com/alan-wu/flatmapvuer/pull/140)
- Feature/3d fc map [`#139`](https://github.com/alan-wu/flatmapvuer/pull/139)
- Hotfix - el-radio props incorrectly changed [`#136`](https://github.com/alan-wu/flatmapvuer/pull/136)
- Cypress testing Vue 3 [`#134`](https://github.com/alan-wu/flatmapvuer/pull/134)
- Update test and dependencies. [`#4`](https://github.com/alan-wu/flatmapvuer/pull/4)
- APIs Documentation [`#133`](https://github.com/alan-wu/flatmapvuer/pull/133)
- Update species selectbox style for hidden contents [`#135`](https://github.com/alan-wu/flatmapvuer/pull/135)
- Fix svg being slighlty to big for its container [`#132`](https://github.com/alan-wu/flatmapvuer/pull/132)
- Featured marker fix [`#128`](https://github.com/alan-wu/flatmapvuer/pull/128)
- Add missing interface [`#131`](https://github.com/alan-wu/flatmapvuer/pull/131)
- Add a property to disable UI elements  [`#130`](https://github.com/alan-wu/flatmapvuer/pull/130)
- Vue3 migration [`#126`](https://github.com/alan-wu/flatmapvuer/pull/126)
- Remove warning [`#3`](https://github.com/alan-wu/flatmapvuer/pull/3)
- fetch vue3 migration changes [`#1`](https://github.com/alan-wu/flatmapvuer/pull/1)
- Allow html in "what's new": [`#125`](https://github.com/alan-wu/flatmapvuer/pull/125)
- Featured marker legend name fix [`#124`](https://github.com/alan-wu/flatmapvuer/pull/124)

### Commits

- Add missing files [`219c3fe`](https://github.com/alan-wu/flatmapvuer/commit/219c3fe91fce576bc6314bd328f2ffaa89d89e3f)
- Remove vuese/cli for npm security vulnerabilities [`bc46469`](https://github.com/alan-wu/flatmapvuer/commit/bc4646969051d750dc02a19c3226c067aea8b809)
- Fix an issue with package-lock.json. [`1d9b9e5`](https://github.com/alan-wu/flatmapvuer/commit/1d9b9e57fc2765fd718ccaa6ac4ecae1aad43b72)

## [v0.5.9](https://github.com/alan-wu/flatmapvuer/compare/v0.5.8...v0.5.9) - 2023-12-08

### Merged

- Annotation UI and connected path  [`#123`](https://github.com/alan-wu/flatmapvuer/pull/123)
- Add the featured markers star to the legend with tooltip [`#122`](https://github.com/alan-wu/flatmapvuer/pull/122)

### Commits

- Increment version. [`c3b98bf`](https://github.com/alan-wu/flatmapvuer/commit/c3b98bfc21720153ff018ae0e61501c00e8c99e7)
- Reset version. [`5f10239`](https://github.com/alan-wu/flatmapvuer/commit/5f10239a05f33b9d6bb1b6c71d02605c0d1c0c58)
- Merge in changes. [`76ee249`](https://github.com/alan-wu/flatmapvuer/commit/76ee249280969445f48af38e9dfe8677d45faa00)

## [v0.5.8](https://github.com/alan-wu/flatmapvuer/compare/v0.5.7...v0.5.8) - 2023-11-07

### Merged

- Update package # [`#120`](https://github.com/alan-wu/flatmapvuer/pull/120)
- Add show/hide for details, add transition [`#119`](https://github.com/alan-wu/flatmapvuer/pull/119)

## [v0.5.7](https://github.com/alan-wu/flatmapvuer/compare/v0.5.6...v0.5.7) - 2023-09-14

### Merged

- Fix a few issues causing neuron search to fail [`#117`](https://github.com/alan-wu/flatmapvuer/pull/117)
- Revert "Add flatmap prov information button" [`#116`](https://github.com/alan-wu/flatmapvuer/pull/116)
- Add flatmap prov information button [`#115`](https://github.com/alan-wu/flatmapvuer/pull/115)

### Commits

- Create a context card for the flatmap prov [`546dca8`](https://github.com/alan-wu/flatmapvuer/commit/546dca85a80d34988404e9de3137ce1acc2d9817)
- Strip out a lot of the context card content [`d4b5d31`](https://github.com/alan-wu/flatmapvuer/commit/d4b5d317c611480ab6d5f9e3537ede03394526bd)
- Add centrelines toggle. [`60c315e`](https://github.com/alan-wu/flatmapvuer/commit/60c315e4a9923d62e7a149ad50c00351915cdd3a)

## [v0.5.6](https://github.com/alan-wu/flatmapvuer/compare/v0.5.5...v0.5.6) - 2023-08-08

### Commits

- Add an accidentally removed line. [`3948001`](https://github.com/alan-wu/flatmapvuer/commit/394800196414108c4e6f8cbf271b53b022818b97)

## [v0.5.5](https://github.com/alan-wu/flatmapvuer/compare/v0.5.4...v0.5.5) - 2023-08-07

### Merged

- Additional settings [`#114`](https://github.com/alan-wu/flatmapvuer/pull/114)
- Add hierarchical control (FC) and species information (AC) [`#113`](https://github.com/alan-wu/flatmapvuer/pull/113)
- Add label for what species provenance info comes from [`#110`](https://github.com/alan-wu/flatmapvuer/pull/110)

### Commits

- Merge in upstream changes. [`39bbcf7`](https://github.com/alan-wu/flatmapvuer/commit/39bbcf7886f22c7c5f7518e7fabcfe23c78db93f)
- Update to the latest flamtap-viewer. [`50d25c3`](https://github.com/alan-wu/flatmapvuer/commit/50d25c3e30f6bf57f60610ace38f1bd283b90cfd)
- Add open map UI. [`11f993e`](https://github.com/alan-wu/flatmapvuer/commit/11f993e3e2882a5ba65b7361ac9a77b86c3944c7)

## [v0.5.4](https://github.com/alan-wu/flatmapvuer/compare/v0.5.3...v0.5.4) - 2023-07-04

## [v0.5.3](https://github.com/alan-wu/flatmapvuer/compare/v0.5.2...v0.5.3) - 2023-07-04

### Merged

- Couple of pop up fixes and remove an unused argument. [`#112`](https://github.com/alan-wu/flatmapvuer/pull/112)
- Remove unused request [`#111`](https://github.com/alan-wu/flatmapvuer/pull/111)

### Commits

- Fix a couple of display issue with tooltip. [`196e1a8`](https://github.com/alan-wu/flatmapvuer/commit/196e1a89bd369d4297252e7e23edbc5ad80435f1)
- Remove unused variable. [`521828d`](https://github.com/alan-wu/flatmapvuer/commit/521828dd0ae43e23078d264793ee40f2bf9ee5a8)
- Fix uberon map for connectivity not being saved as a variable [`643690e`](https://github.com/alan-wu/flatmapvuer/commit/643690efc58934b8028bda592149179339ed7b9b)

## [v0.5.2](https://github.com/alan-wu/flatmapvuer/compare/v0.5.1...v0.5.2) - 2023-06-15

### Commits

- Fix an issue with flatmap queries not using the right name. [`eaf6167`](https://github.com/alan-wu/flatmapvuer/commit/eaf6167a1b7ff7426f313cf0231a1fc017e68752)

## [v0.5.1](https://github.com/alan-wu/flatmapvuer/compare/v0.5.0...v0.5.1) - 2023-06-15

### Commits

- Udpate dependencies. [`943e51f`](https://github.com/alan-wu/flatmapvuer/commit/943e51fc4f88014d6c3c9fae2b99d3ffa6465fd2)
- Revert changes in dependencies. [`3a70807`](https://github.com/alan-wu/flatmapvuer/commit/3a708074cc05a1b10e14b2bc33790cd934479469)

## [v0.5.0](https://github.com/alan-wu/flatmapvuer/compare/v0.4.6...v0.5.0) - 2023-06-12

### Merged

- Update build [`#107`](https://github.com/alan-wu/flatmapvuer/pull/107)
- Fix provenance logic: [`#109`](https://github.com/alan-wu/flatmapvuer/pull/109)

### Commits

- Downgrade to vue 2.6.14 [`a81b049`](https://github.com/alan-wu/flatmapvuer/commit/a81b049813301700e3ea16dad0d7f7109433f362)
- Merge in upstream changes, [`f490c11`](https://github.com/alan-wu/flatmapvuer/commit/f490c1171d591b57987f6b6f81a3dd62feaac293)
- Update vue version to 2.7.14 [`5eeadec`](https://github.com/alan-wu/flatmapvuer/commit/5eeadecce6ea554c806d5b2c0db50fb92e9ec7a6)

## [v0.4.6](https://github.com/alan-wu/flatmapvuer/compare/0.4.6-fixes-2...v0.4.6) - 2023-06-01

## [0.4.6-fixes-2](https://github.com/alan-wu/flatmapvuer/compare/v0.4.6-fixes-0...0.4.6-fixes-2) - 2023-06-05

### Commits

- Version 0.4.6-fixes-1 [`e8b60c3`](https://github.com/alan-wu/flatmapvuer/commit/e8b60c3e9bf381f4af68bd95612cdd20ea3132d0)
- Rename mapboxgl in css rules to maplibregl. [`9040cc9`](https://github.com/alan-wu/flatmapvuer/commit/9040cc96d32bb076c14c05af52f79a7137cd2651)
- Search will display the label and location of the highest score result. [`c3b2e47`](https://github.com/alan-wu/flatmapvuer/commit/c3b2e471ed3bb6eb61c078c903814f40d57ca3fa)

## [v0.4.6-fixes-0](https://github.com/alan-wu/flatmapvuer/compare/v0.4.5...v0.4.6-fixes-0) - 2023-06-01

### Commits

- Fix an issue with poppver does not dismiss. [`c26cd14`](https://github.com/alan-wu/flatmapvuer/commit/c26cd143211247c0b58dad0379ac14c69b6edc0e)
- Fix the version of flatmap-viewer at 0.2.3.2-b.4 [`d7692a2`](https://github.com/alan-wu/flatmapvuer/commit/d7692a20b855e5550c74962dd416515b9b67cdce)
- 0.4.6 release. [`d6e0e01`](https://github.com/alan-wu/flatmapvuer/commit/d6e0e014c450c7f3a2f091db4f8f70dbadbeb157)

## [v0.4.5](https://github.com/alan-wu/flatmapvuer/compare/v0.4.2...v0.4.5) - 2023-06-01

### Merged

- Update beta text. [`#108`](https://github.com/alan-wu/flatmapvuer/pull/108)
- Fix pubmed resource logic [`#106`](https://github.com/alan-wu/flatmapvuer/pull/106)

### Commits

- Update flatmap-viewer [`4dfeb29`](https://github.com/alan-wu/flatmapvuer/commit/4dfeb296889802cee878d14c1143b99a8ed8fd7d)
- Remove debug code, update package # [`4d226fa`](https://github.com/alan-wu/flatmapvuer/commit/4d226faa084b80e76ee78e9f445f47173909e113)
- Version 0.4.5 [`d28daf4`](https://github.com/alan-wu/flatmapvuer/commit/d28daf48614e67568865bd0c1ae2309d5e90cbfa)

## [v0.4.2](https://github.com/alan-wu/flatmapvuer/compare/v0.4.1...v0.4.2) - 2023-05-10

### Commits

- Fix an issue with setting state before mounted. [`73d6cc1`](https://github.com/alan-wu/flatmapvuer/commit/73d6cc11005568c6b00f3dd322ff778b12373f63)

## [v0.4.1](https://github.com/alan-wu/flatmapvuer/compare/v0.4.0...v0.4.1) - 2023-05-10

### Merged

- Update controls and tidy up [`#105`](https://github.com/alan-wu/flatmapvuer/pull/105)
- Resolve promise list with 'true/false' for whether to display tooltip [`#104`](https://github.com/alan-wu/flatmapvuer/pull/104)
- Remove services from package.json [`#103`](https://github.com/alan-wu/flatmapvuer/pull/103)
- Switch class to function as it was breaking mapintegrated build [`#102`](https://github.com/alan-wu/flatmapvuer/pull/102)
- Queries refactor [`#101`](https://github.com/alan-wu/flatmapvuer/pull/101)
- V0.4.0 [`#100`](https://github.com/alan-wu/flatmapvuer/pull/100)

### Commits

- Use new FC map [`e54bf3c`](https://github.com/alan-wu/flatmapvuer/commit/e54bf3cfa5031020f136251d3691d3d1f05a1971)
- Update version number. [`cd32fa9`](https://github.com/alan-wu/flatmapvuer/commit/cd32fa955bff0b38c29271f30cacc106f1355cb2)
- Move toolip logic to flatmapQueries.js [`9b09d0c`](https://github.com/alan-wu/flatmapvuer/commit/9b09d0c97e218e7799071aedecd7193441954a3d)

## [v0.4.0](https://github.com/alan-wu/flatmapvuer/compare/v0.3.15...v0.4.0) - 2023-04-04

### Merged

- Prov pop up feedback [`#97`](https://github.com/alan-wu/flatmapvuer/pull/97)
- Rename Change background colour to change settings. [`#96`](https://github.com/alan-wu/flatmapvuer/pull/96)

### Commits

- Create a new vue component for the selection controls. [`aed5e35`](https://github.com/alan-wu/flatmapvuer/commit/aed5e3598d4d1fc8d6dd34a0cb7541066d155751)
- update flatmap-viewer to 2.2.13 [`f8e0dc8`](https://github.com/alan-wu/flatmapvuer/commit/f8e0dc8473b37935dc24b9765569ed5c9d26604d)
- Update flatmap-viewer. [`33c53dc`](https://github.com/alan-wu/flatmapvuer/commit/33c53dc53989823f934235e6ebbfe2a8bd1652a9)

## [v0.3.15](https://github.com/alan-wu/flatmapvuer/compare/v0.3.12...v0.3.15) - 2023-02-27

### Merged

- Fix minimap sizing issue and make sure flatmap-viewer 2.2.9 is used [`#95`](https://github.com/alan-wu/flatmapvuer/pull/95)
- Remove call to function that does not exist [`#94`](https://github.com/alan-wu/flatmapvuer/pull/94)
- Update package # and publish [`#93`](https://github.com/alan-wu/flatmapvuer/pull/93)
- Minimap hideable [`#92`](https://github.com/alan-wu/flatmapvuer/pull/92)
- Improve initialisation and search  [`#91`](https://github.com/alan-wu/flatmapvuer/pull/91)

### Commits

- Move code to flatmapvuer, fix transform origin [`a630ed8`](https://github.com/alan-wu/flatmapvuer/commit/a630ed85806cf008d6b3d36d3ee270994341b86e)
- Add an additional flag to allow label to be displayed with the searchAndShowResult function. [`5f6c57b`](https://github.com/alan-wu/flatmapvuer/commit/5f6c57b7fc4eb062c6b00b80e95f007f3bd0a95a)
- Improve state loading. [`f695883`](https://github.com/alan-wu/flatmapvuer/commit/f6958831c23fa9539463182509e1b55620eb9521)

## [v0.3.12](https://github.com/alan-wu/flatmapvuer/compare/v0.3.12-fixes-0...v0.3.12) - 2023-01-20

## [v0.3.12-fixes-0](https://github.com/alan-wu/flatmapvuer/compare/v0.3.10...v0.3.12-fixes-0) - 2023-01-20

### Merged

- Permalink update [`#90`](https://github.com/alan-wu/flatmapvuer/pull/90)
- Now search on model for pubmed ids [`#85`](https://github.com/alan-wu/flatmapvuer/pull/85)

### Commits

- Flatmapvuer now uses uuid to fetch the map when saved in state. [`af447d3`](https://github.com/alan-wu/flatmapvuer/commit/af447d3e73bb8324d636b4831d7527d821704a60)
- Cut down pubmedviewer, organise tooltip proccessing [`dde4b8b`](https://github.com/alan-wu/flatmapvuer/commit/dde4b8b62808475dac4e4cc2ecbbcc72c48d1196)
- Increment version number to 0.3.11. [`a7509fd`](https://github.com/alan-wu/flatmapvuer/commit/a7509fdbd4f6914f4362f2e526362ca8248b1a5e)

## [v0.3.10](https://github.com/alan-wu/flatmapvuer/compare/0.3.9...v0.3.10) - 2022-12-13

### Commits

- Update to the latest version of flatmap-viewer. [`775fd65`](https://github.com/alan-wu/flatmapvuer/commit/775fd6551877e1219fb63e675be2ce31a2eb8a36)
- Add css for other neruon type. [`a8df0c5`](https://github.com/alan-wu/flatmapvuer/commit/a8df0c5cb03448a3b3bc5ab6e709206aee54f526)
- Start storing uuid when saving the state. [`21cea3e`](https://github.com/alan-wu/flatmapvuer/commit/21cea3eb1dbd58795482f29b7c2e5ed198fb7d63)

## [0.3.9](https://github.com/alan-wu/flatmapvuer/compare/0.3.8...0.3.9) - 2022-12-08

### Merged

- Update to the latest flatmap [`#84`](https://github.com/alan-wu/flatmapvuer/pull/84)

### Commits

- Update to flatmap-viewer 2.2.7 and change the way maps are found. [`c2ae329`](https://github.com/alan-wu/flatmapvuer/commit/c2ae3297fb167e68515f8c779c4ce4222ea48211)

## [0.3.8](https://github.com/alan-wu/flatmapvuer/compare/0.3.3...0.3.8) - 2022-12-02

### Merged

- Add legends [`#83`](https://github.com/alan-wu/flatmapvuer/pull/83)
- Update node processing to display labels correctly [`#75`](https://github.com/alan-wu/flatmapvuer/pull/75)
- Switch to new colors [`#81`](https://github.com/alan-wu/flatmapvuer/pull/81)
- Run npm install and update package # [`#76`](https://github.com/alan-wu/flatmapvuer/pull/76)
- Latest changes message [`#74`](https://github.com/alan-wu/flatmapvuer/pull/74)

### Commits

- Use the latest version of flatmap-viewer and update the endpoint. [`ecc5174`](https://github.com/alan-wu/flatmapvuer/commit/ecc517468aecab36097b29fd794f4e05fd8be1db)
- Begin working on legends. [`eb225cb`](https://github.com/alan-wu/flatmapvuer/commit/eb225cbe6285ff0030a03710a0f940b79e464311)
- Fix the creation of labels from nodes [`c28653a`](https://github.com/alan-wu/flatmapvuer/commit/c28653ad3534677d51fd29f666b5b036b8939e37)

## [0.3.3](https://github.com/alan-wu/flatmapvuer/compare/v0.3.1...0.3.3) - 2022-08-19

### Merged

- Add success pop-up [`#71`](https://github.com/alan-wu/flatmapvuer/pull/71)

### Commits

- Add props to display and customis the latest changes message. [`494c3d8`](https://github.com/alan-wu/flatmapvuer/commit/494c3d8d6f86038495925704d676cbce91a665ed)
- Rename 'success' to 'latestChanges' [`6bec159`](https://github.com/alan-wu/flatmapvuer/commit/6bec15969d4fa6cfb28cfeddb89ec813c4343d6c)
- Fix tooltip boolean numbers [`76c4481`](https://github.com/alan-wu/flatmapvuer/commit/76c448124476d3a16fb9633ce1ad8e95653b5cf9)

## [v0.3.1](https://github.com/alan-wu/flatmapvuer/compare/v0.3.0...v0.3.1) - 2022-07-29

### Merged

- Add scrollbar to the pathway popups [`#70`](https://github.com/alan-wu/flatmapvuer/pull/70)
- Bump async from 2.6.3 to 2.6.4 [`#63`](https://github.com/alan-wu/flatmapvuer/pull/63)
- Bump terser from 4.8.0 to 4.8.1 [`#67`](https://github.com/alan-wu/flatmapvuer/pull/67)
- Bump minimist from 1.2.5 to 1.2.6 [`#61`](https://github.com/alan-wu/flatmapvuer/pull/61)
- Bump shell-quote from 1.7.2 to 1.7.3 [`#68`](https://github.com/alan-wu/flatmapvuer/pull/68)
- Bump eventsource from 1.1.0 to 1.1.2 [`#69`](https://github.com/alan-wu/flatmapvuer/pull/69)

### Commits

- Switch to using scrollbar for tooltips [`6467659`](https://github.com/alan-wu/flatmapvuer/commit/646765986db012aaa86985a69ab6c46571a46f66)
- Increment to version 0.3.0 [`6cdebde`](https://github.com/alan-wu/flatmapvuer/commit/6cdebde6fb62f24ed25989fedf54cae5d6380f16)
- Update package # [`9999102`](https://github.com/alan-wu/flatmapvuer/commit/9999102256526f65984534f26c174d062863e426)

## [v0.3.0](https://github.com/alan-wu/flatmapvuer/compare/v0.3.0-beta-2...v0.3.0) - 2022-07-22

### Merged

- Upstream downstream pop ups [`#64`](https://github.com/alan-wu/flatmapvuer/pull/64)

### Commits

- Refactor axon-&gt;destination dendrite-&gt;origin [`2e8ad3e`](https://github.com/alan-wu/flatmapvuer/commit/2e8ad3efeeaa22987071215922540cdacb313e9d)
- Update flatmap-viewer, no longer tooltips for nerve cuffs [`be23067`](https://github.com/alan-wu/flatmapvuer/commit/be2306743b5353617d0258a50688b3c97fcfc958)
- split up popup boolean and creation [`5fe897c`](https://github.com/alan-wu/flatmapvuer/commit/5fe897cc7afe2ba467531cdd261f70107e3e0af7)

## [v0.3.0-beta-2](https://github.com/alan-wu/flatmapvuer/compare/v0.3.0-beta-1...v0.3.0-beta-2) - 2022-05-23

### Commits

- Improve label lookup. [`fceec12`](https://github.com/alan-wu/flatmapvuer/commit/fceec12276af56d28a9fbbc1f88c7bc984b17aef)

## [v0.3.0-beta-1](https://github.com/alan-wu/flatmapvuer/compare/v0.3.0-beta-0...v0.3.0-beta-1) - 2022-05-23

### Commits

- Handle missing data gratefully. [`875c5a0`](https://github.com/alan-wu/flatmapvuer/commit/875c5a0402808e0e05a6b58f708edcd6fbc47bf5)

## [v0.3.0-beta-0](https://github.com/alan-wu/flatmapvuer/compare/v0.2.5...v0.3.0-beta-0) - 2022-05-23

### Commits

- Create upstream-downstream tooltips [`3d2215f`](https://github.com/alan-wu/flatmapvuer/commit/3d2215f2d8ce6c2c4615505dac27c034d6b53434)
- Add pubmed queries for nerve cuffs [`81ec823`](https://github.com/alan-wu/flatmapvuer/commit/81ec8239dc7c5d7476a496797df33420532b8852)
- Make semicolons consistent and use provide/inject for apis [`60bd15d`](https://github.com/alan-wu/flatmapvuer/commit/60bd15d2984425c0a3f73b5d051634e936002230)

## [v0.2.5](https://github.com/alan-wu/flatmapvuer/compare/v0.2.5-beta-1...v0.2.5) - 2022-05-19

### Merged

- Build in element ui to avoid styles being used in global space. [`#65`](https://github.com/alan-wu/flatmapvuer/pull/65)

## [v0.2.5-beta-1](https://github.com/alan-wu/flatmapvuer/compare/v0.1.33...v0.2.5-beta-1) - 2022-05-11

### Merged

- Pan zoom events. Icon updates. Show/hide UI APIs. [`#62`](https://github.com/alan-wu/flatmapvuer/pull/62)
- Bump url-parse from 1.5.3 to 1.5.10 [`#60`](https://github.com/alan-wu/flatmapvuer/pull/60)
- Bump follow-redirects from 1.14.7 to 1.14.8 [`#58`](https://github.com/alan-wu/flatmapvuer/pull/58)
- Fix an issue with icon [`#56`](https://github.com/alan-wu/flatmapvuer/pull/56)
- Fix a bug causing compilation error upstream. [`#55`](https://github.com/alan-wu/flatmapvuer/pull/55)
- Increment package version  [`#54`](https://github.com/alan-wu/flatmapvuer/pull/54)
- Update tooltip for non-rat flatmaps [`#53`](https://github.com/alan-wu/flatmapvuer/pull/53)
- Use Scss instead. [`#52`](https://github.com/alan-wu/flatmapvuer/pull/52)
- Dynamic markers,  outline and colour chooser. [`#51`](https://github.com/alan-wu/flatmapvuer/pull/51)
- Species check [`#49`](https://github.com/alan-wu/flatmapvuer/pull/49)
- Set background colour and opacity at start up. [`#3`](https://github.com/alan-wu/flatmapvuer/pull/3)
- Tehsurfer gazelle pop ups [`#2`](https://github.com/alan-wu/flatmapvuer/pull/2)
- Resolve conflicts and bugs. [`#1`](https://github.com/alan-wu/flatmapvuer/pull/1)

### Commits

- Increment package version. [`19f90a8`](https://github.com/alan-wu/flatmapvuer/commit/19f90a8aa3a3b3c103f7b4a7f18c46fa001b4b95)
- Stylesheets are now in scss. [`4a944f3`](https://github.com/alan-wu/flatmapvuer/commit/4a944f35257a7e34b0144d111845f0cf4273f816)
- Update package-lock.json [`f0afe8f`](https://github.com/alan-wu/flatmapvuer/commit/f0afe8f369ecb42e91ef97f626bc5ad4fb7887c9)

## v0.1.33 - 2021-06-21

### Merged

- Improve tooltip style. [`#48`](https://github.com/alan-wu/flatmapvuer/pull/48)
- UI improvements [`#46`](https://github.com/alan-wu/flatmapvuer/pull/46)
- Update flatmap viewer which include an update on callback. [`#45`](https://github.com/alan-wu/flatmapvuer/pull/45)
- Add an option to set the flatmap api endpoint. [`#44`](https://github.com/alan-wu/flatmapvuer/pull/44)
- Implement saving/getting state of flatmap  [`#43`](https://github.com/alan-wu/flatmapvuer/pull/43)
- Update dependencies. [`#42`](https://github.com/alan-wu/flatmapvuer/pull/42)
- Export is now named. Version updated to 0.1.28. [`#41`](https://github.com/alan-wu/flatmapvuer/pull/41)
- Now built without bundling external node modules. [`#40`](https://github.com/alan-wu/flatmapvuer/pull/40)
- Documentation [`#38`](https://github.com/alan-wu/flatmapvuer/pull/38)
- Fix Display all checkbox problem with reset. [`#37`](https://github.com/alan-wu/flatmapvuer/pull/37)
- Version0.1.25 [`#36`](https://github.com/alan-wu/flatmapvuer/pull/36)
- Version0.1.24 [`#35`](https://github.com/alan-wu/flatmapvuer/pull/35)
- Version0.1.23 [`#34`](https://github.com/alan-wu/flatmapvuer/pull/34)
- Tooltip update [`#33`](https://github.com/alan-wu/flatmapvuer/pull/33)
- Versions.1.22 [`#32`](https://github.com/alan-wu/flatmapvuer/pull/32)
- Version0.1.21 [`#31`](https://github.com/alan-wu/flatmapvuer/pull/31)
- Bump version to 0.1.20. [`#30`](https://github.com/alan-wu/flatmapvuer/pull/30)
- Added Help hovers [`#28`](https://github.com/alan-wu/flatmapvuer/pull/28)
- Add a button to toggle the background colour. [`#29`](https://github.com/alan-wu/flatmapvuer/pull/29)
- Version0.1.19 [`#27`](https://github.com/alan-wu/flatmapvuer/pull/27)
- Version0.1.18 [`#26`](https://github.com/alan-wu/flatmapvuer/pull/26)
- Version0.1.17 [`#25`](https://github.com/alan-wu/flatmapvuer/pull/25)
- Version0.1.16 [`#24`](https://github.com/alan-wu/flatmapvuer/pull/24)
- Version0.1.15 [`#23`](https://github.com/alan-wu/flatmapvuer/pull/23)
- Bump flatmap viewer and this package version. [`#22`](https://github.com/alan-wu/flatmapvuer/pull/22)
- Version0.1.13 [`#21`](https://github.com/alan-wu/flatmapvuer/pull/21)
- Version0.1.12 [`#19`](https://github.com/alan-wu/flatmapvuer/pull/19)
- Update flatmap viewer to 0.9.10. [`#18`](https://github.com/alan-wu/flatmapvuer/pull/18)
- Viewe0.9.9 test [`#1`](https://github.com/alan-wu/flatmapvuer/pull/1)
- Add emit for when flatmap is changed [`#17`](https://github.com/alan-wu/flatmapvuer/pull/17)
- Updaet flatmapviewer. [`#16`](https://github.com/alan-wu/flatmapvuer/pull/16)
- Bump version and make some stylistic changes. [`#15`](https://github.com/alan-wu/flatmapvuer/pull/15)
- Bump flatmap version to 0.9.4 [`#14`](https://github.com/alan-wu/flatmapvuer/pull/14)
- Add the apis required to display a popup. [`#13`](https://github.com/alan-wu/flatmapvuer/pull/13)
- Add the ability to adjust species at startup. [`#12`](https://github.com/alan-wu/flatmapvuer/pull/12)
- Increment version number [`#11`](https://github.com/alan-wu/flatmapvuer/pull/11)
- Update map viewer to v0.9.3 [`#10`](https://github.com/alan-wu/flatmapvuer/pull/10)
- Flatmap viewer 0.9 release [`#9`](https://github.com/alan-wu/flatmapvuer/pull/9)
- Add a multiflatmapvuer. [`#8`](https://github.com/alan-wu/flatmapvuer/pull/8)
- Remove undefined label from returned labels list. [`#7`](https://github.com/alan-wu/flatmapvuer/pull/7)
- Add ready event, getLabels and stylistic changes. [`#6`](https://github.com/alan-wu/flatmapvuer/pull/6)
- Add label to payload. [`#5`](https://github.com/alan-wu/flatmapvuer/pull/5)
- Fix a critical bug. [`#4`](https://github.com/alan-wu/flatmapvuer/pull/4)
- Add README.md. [`#3`](https://github.com/alan-wu/flatmapvuer/pull/3)
- Use resizeSensor to detect resizing. [`#2`](https://github.com/alan-wu/flatmapvuer/pull/2)
- First revision of the vue component of flatmap viwer. [`#1`](https://github.com/alan-wu/flatmapvuer/pull/1)

### Commits

- Increment version to 0.1.33. [`3202fa0`](https://github.com/alan-wu/flatmapvuer/commit/3202fa043c2e511994ce239e860c576dbaf155b9)
- Increment flatmapviewer to 1.0.3 which fixes cases of labels. [`7564d1d`](https://github.com/alan-wu/flatmapvuer/commit/7564d1dc5b431f9546f9ba90d10e3ed1d3f21060)
- Add more support for flatmap v0.9.2. [`b74b957`](https://github.com/alan-wu/flatmapvuer/commit/b74b957a4e3848f26e4bc0f97b1eed89a51bfe01)
